attribute vec4 position;
varying vec2 tc;
uniform int flip; 

void main()
{	
	gl_Position = vec4(position.xy, 0.0, 1.0);
	tc = (position.xy+1.0)/2.0;
	
	if (flip==0)
		tc.y = 1.0-tc.y;
}	

//FRAGMENT

#version 120
varying vec2 tc; 
uniform sampler2D Texture0; 
uniform float cut_off; 
uniform float ty; //texel - linear sampler..
uniform float tx; //texel - linear sampler
uniform vec2 dir; //(1, 0) or (0, 1)
uniform float weights[64];
uniform int taps; 


vec4 tex2Dcut(vec2 tc) {
	vec4 p = max(vec4(0.0), texture2D(Texture0, tc)-cut_off);
	//p = clamp(p, vec4(0.f), vec4(1.0f));
	return p;//pow(p, vec4(1.0/2.2));
}


void main(void)
{   

	vec4 sum = vec4(0.f);
	int j=0;
	//for(int i=-taps;i<(taps+1);i++) {
	
	
	for(int i=-taps/2;i<(taps/2+1);i++) {
		vec2 add = vec2(i)*vec2(ty, ty)*dir*1.0;//.5250;
		//add*=0.0;
		//sum += texture2D(Texture0, tc+add)*weights[j];
		sum += tex2Dcut(tc+add)*weights[j];
		
		j+=1;
	}

	

/*
	for(int i=0;i<(taps/2-1);i++) {
		vec2 add = vec2(i)*vec2(tx, 0.0f)*dir*20.0;

		sum+= tex2Dcut(tc+add)*weights[i];
		sum+= tex2Dcut(tc-add)*weights[i];
	}
	*/

	//sum+= tex2Dcut(tc);

	gl_FragColor = sum;
	//gl_FragColor =  texture2D(Texture0, tc);// tex2Dcut(tc);
}
